/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.task;

import com.ibm.hwmca.fw.managed.ObjectId;
import com.ibm.hwmca.fw.task.PresentationTaskParms;
import com.ibm.hwmca.fw.task.ProgressCancelListener;
import com.ibm.hwmca.fw.task.ProgressData;
import com.ibm.hwmca.fw.task.ProgressEndedListener;
import com.ibm.hwmca.fw.task.ProgressEvent;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class ProgressStartEvent
extends ProgressEvent {
    private static final String TRACE_MASKT = "XFRMPSET";
    private static final String TRACE_MASKF = "XFRMPSEF";
    private static final String TRACE_MASKD = "XFRMPSED";
    private LocalizableText taskName;
    private LocalizableText text;
    private long taskDurationTime = 0L;
    private ProgressData[] progressData = null;
    private ProgressCancelListener progressCancelListener = null;
    private ProgressEndedListener progressEndedListener = null;
    private String helpInfo = null;

    private void initialize(LocalizableText taskName, ProgressData[] progressData, long taskDurationTime, LocalizableText text, ProgressCancelListener progressCancelListener, ProgressEndedListener progressEndedListener) throws IllegalArgumentException {
        int i;
        Trace.trace(TRACE_MASKT, "-> ProgressStartEvent.initialize()");
        if (progressData == null) {
            IllegalArgumentException exc = new IllegalArgumentException("null progress data specified");
            throw exc;
        }
        if (taskName == null) {
            IllegalArgumentException exc = new IllegalArgumentException("null task name specified");
            throw exc;
        }
        this.taskName = taskName;
        this.progressData = progressData;
        this.taskDurationTime = taskDurationTime;
        this.text = text;
        this.progressCancelListener = progressCancelListener;
        this.progressEndedListener = progressEndedListener;
        if (text != null) {
            for (i = 0; i < progressData.length; ++i) {
                if (progressData[i].getText() != null) continue;
                progressData[i].setText(text);
            }
        }
        if (taskDurationTime != 0L) {
            for (i = 0; i < progressData.length; ++i) {
                if (progressData[i].getDurationTime() != 0L) continue;
                progressData[i].setDurationTime(taskDurationTime);
            }
        }
        this.sortData();
        Trace.trace(TRACE_MASKT, "<- ProgressStartEvent.initialize()");
    }

    public ProgressStartEvent(LocalizableText taskName, ProgressData[] progressData, long taskDurationTime, LocalizableText text, String id, ProgressCancelListener progressCancelListener, ProgressEndedListener progressEndedListener) throws IllegalArgumentException {
        super(id);
        this.initialize(taskName, progressData, taskDurationTime, text, progressCancelListener, progressEndedListener);
    }

    public ProgressStartEvent(LocalizableText taskName, ProgressData[] progressData, long taskDurationTime, LocalizableText text, String id) throws IllegalArgumentException {
        this(taskName, progressData, taskDurationTime, text, id, null, null);
    }

    public ProgressStartEvent(PresentationTaskParms parms, LocalizableText taskName, long taskDurationTime, LocalizableText text, String id, ProgressCancelListener progressCancelListener, ProgressEndedListener progressEndedListener) throws IllegalArgumentException {
        super(id);
        ProgressData[] theProgressData;
        Trace.trace(TRACE_MASKT, "-> ProgressStartEvent.ctor1()");
        if (text == null) {
            throw new IllegalArgumentException("null text specified");
        }
        if (taskDurationTime == 0L) {
            throw new IllegalArgumentException("invalid task duration time specified");
        }
        if (parms == null) {
            throw new IllegalArgumentException("null presentation task parms specified");
        }
        ObjectId[] targets = parms.getTargetIds();
        if (targets != null && targets.length > 0) {
            theProgressData = new ProgressData[targets.length];
            for (int i = 0; i < targets.length; ++i) {
                theProgressData[i] = new ProgressData(targets[i]);
                theProgressData[i].setDurationTime(taskDurationTime);
            }
        } else {
            theProgressData = new ProgressData[]{new ProgressData()};
            theProgressData[0].setDurationTime(taskDurationTime);
        }
        this.initialize(taskName, theProgressData, taskDurationTime, text, progressCancelListener, progressEndedListener);
        Trace.trace(TRACE_MASKT, "<- ProgressStartEvent.ctor1()");
    }

    public ProgressStartEvent(PresentationTaskParms parms, LocalizableText taskName, long taskDurationTime, LocalizableText text, String id) throws IllegalArgumentException {
        this(parms, taskName, taskDurationTime, text, id, null, null);
    }

    public LocalizableText getTaskName() {
        return this.taskName;
    }

    public LocalizableText getText() {
        return this.text;
    }

    public long getTaskDurationTime() {
        return this.taskDurationTime;
    }

    public ProgressData[] getProgressData() {
        return this.progressData;
    }

    boolean changeProgressData(ProgressData[] data, boolean operation) {
        boolean changed = false;
        if (data != null && data.length > 0) {
            int i;
            HashMap<ObjectId, ProgressData> datamap = new HashMap<ObjectId, ProgressData>();
            for (i = 0; i < this.progressData.length; ++i) {
                datamap.put(this.progressData[i].getObjectId(), this.progressData[i]);
            }
            for (i = 0; i < data.length; ++i) {
                if (data[i] == null) continue;
                boolean exists = datamap.containsKey(data[i].getObjectId());
                if (operation) {
                    if (exists) continue;
                    datamap.put(data[i].getObjectId(), data[i]);
                    changed = true;
                    continue;
                }
                if (!exists) continue;
                datamap.remove(data[i].getObjectId());
                changed = true;
            }
            if (changed) {
                Collection values = datamap.values();
                ProgressData[] newData = new ProgressData[values.size()];
                this.progressData = (ProgressData[])values.toArray((Object[])newData);
                this.sortData();
            }
        }
        return changed;
    }

    public ProgressCancelListener getProgressCancelListener() {
        return this.progressCancelListener;
    }

    public void setProgressCancelListener(ProgressCancelListener progressCancelListener) {
        this.progressCancelListener = progressCancelListener;
    }

    public ProgressEndedListener getProgressEndedListener() {
        return this.progressEndedListener;
    }

    public void setProgressEndedListener(ProgressEndedListener progressEndedListener) {
        this.progressEndedListener = progressEndedListener;
    }

    public boolean isCancelSupported() {
        return this.progressCancelListener != null;
    }

    public void setHelpInfo(String helpInfo) {
        this.helpInfo = helpInfo;
    }

    public String getHelpInfo() {
        return this.helpInfo;
    }

    private void sortData() {
        TreeMap<String, ProgressData> map = new TreeMap<String, ProgressData>();
        if (this.progressData.length > 1) {
            for (int i = 0; i < this.progressData.length; ++i) {
                map.put(this.progressData[i].getName().toString(), this.progressData[i]);
            }
            ProgressData[] newData = new ProgressData[this.progressData.length];
            Set set = map.entrySet();
            int j = 0;
            Iterator i = set.iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                newData[j] = (ProgressData)entry.getValue();
                ++j;
            }
            this.progressData = newData;
        }
    }
}

